/**
****************************************************************************************
* @file    : task_c0_rx .c
* @author  : Samir
* @version : V1.0
* @date    : 2024-11-25
* @brief   : can0 
****************************************************************************************
* @attention
*            
*
*
****************************************************************************************
*/
#include "task_c0_rx.h"
#include "./can/bsp_can.h"


/**
 * @brief   can0 
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
void c0_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    can_data_t *p_can_data = NULL;
    uint32_t num = 0x0;

    uint8_t data[8] = {0x81, 0x02, 0x83, 0x04, 0x05, 0x06, 0x07, 0x08};
    LOG_INFO(0, "---c0_rx_task_fun start---\n");

    while (1)
    {
        if (xQueueReceive(c0_rx_queue_handle, &p_can_data, portMAX_DELAY) == pdTRUE)
        {
            num++;

            LOG_INFO(0, "num=%d_id=0x%x\n", num, p_can_data->can_id);            
        }
    }
}

/**
 * @brief   can1 
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
void c1_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    can_data_t *p_can_data = NULL;
    uint32_t num1 = 0x0;
    LOG_INFO(1, "---c1_rx_task_fun start---\n");

    while (1)
    {
        if (xQueueReceive(c1_rx_queue_handle, &p_can_data, portMAX_DELAY) == pdTRUE)
        {
            num1++;

            LOG_INFO(1, "num1=%d_id=0x%x\n", num1, p_can_data->can_id);   
        }
    }
}

/**
 * @brief   can2 
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
void c2_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    can_data_t *p_can_data = NULL;
    uint32_t num2 = 0x0;
    LOG_INFO(2, "---c2_rx_task_fun start---\n");

    while (1)
    {
        if (xQueueReceive(c2_rx_queue_handle, &p_can_data, portMAX_DELAY) == pdTRUE)
        {
            num2++;

            LOG_INFO(2, "num2=%d_id=0x%x\n", num2, p_can_data->can_id);   
        }
    }
}

/**
 * @brief   can3 
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
void c3_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    can_data_t *p_can_data = NULL;
    uint32_t num3 = 0x0;
    LOG_INFO(3, "---c3_rx_task_fun start---\n");

    while (1)
    {
        if (xQueueReceive(c3_rx_queue_handle, &p_can_data, 100) == pdTRUE)
        {
            num3++;

            LOG_INFO(3, "num3=%d_id=0x%x\n", num3, p_can_data->can_id);
        }
    }
}

/**
 * @brief   can4 
 * @param   pvParameters:
 * @author  Samir
 * @version 1.0
 * @date    2024-11-25
 */
void c4_rx_task_fun(void *pvParameters)
{
    (void)pvParameters;
    can_data_t *p_can_data = NULL;

    uint32_t num4 = 0;

    LOG_INFO(4, "---c4_rx_task_fun start---\n");

    while (1)
    {
        if (xQueueReceive(c4_rx_queue_handle, &p_can_data, portMAX_DELAY) == pdTRUE)
        {
            num4++;

            LOG_INFO(4, "num4=%d_id=0x%x\n", num4, p_can_data->can_id);
        }
        
    }
}

/************************************* END OF FILE ************************************/